/*
 * Decompiled with CFR 0.152.
 */
package com.wynprice.secretrooms.client.model;

import com.wynprice.secretrooms.client.model.SecretBlockModel;
import com.wynprice.secretrooms.client.model.quads.NoTintBakedQuadRetextured;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OneWayGlassModel
extends SecretBlockModel {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static BakedModel glassModel;

    public OneWayGlassModel(BakedModel model) {
        super(model);
    }

    @Override
    protected boolean canRenderInLater(BlockState state) {
        return MinecraftForgeClient.getRenderType() == RenderType.m_110463_() || super.canRenderInLater(state);
    }

    @Override
    public List<BakedQuad> render(@Nonnull BlockState mirrorState, @Nonnull BlockState baseState, @Nonnull BakedModel model, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        RenderType startLayer = MinecraftForgeClient.getRenderType();
        Supplier<List<BakedQuad>> superQuads = () -> this.getQuadsForSide(mirrorState, baseState, side, rand, extraData);
        List<BakedQuad> out = this.getQuadsNotSolid(baseState, mirrorState, superQuads, extraData);
        ForgeHooksClient.setRenderType((RenderType)startLayer);
        return out;
    }

    private List<BakedQuad> getQuadsNotSolid(BlockState baseState, BlockState delegate, Supplier<List<BakedQuad>> superQuads, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        RenderType layer = MinecraftForgeClient.getRenderType();
        if (layer == null || layer == RenderType.m_110463_()) {
            quads.addAll(this.getGlassQuadsNotSolid(baseState, superQuads, extraData));
        }
        if (layer == null || ItemBlockRenderTypes.canRenderInLayer((BlockState)delegate, (RenderType)layer)) {
            quads.addAll(this.getDelegateQuadsNotSolid(baseState, superQuads));
        }
        return quads;
    }

    private List<BakedQuad> getGlassQuadsNotSolid(BlockState baseState, Supplier<List<BakedQuad>> superQuads, IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : this.gatherAllQuads(superQuads)) {
            if (!((Boolean)baseState.m_61143_((Property)PipeBlock.f_55154_.get(bakedQuad.m_111306_()))).booleanValue()) continue;
            quads.add(new NoTintBakedQuadRetextured(bakedQuad, glassModel.getParticleIcon(extraData)));
        }
        return quads;
    }

    private List<BakedQuad> getDelegateQuadsNotSolid(BlockState baseState, Supplier<List<BakedQuad>> superQuads) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (BakedQuad bakedQuad : superQuads.get()) {
            if (((Boolean)baseState.m_61143_((Property)PipeBlock.f_55154_.get(bakedQuad.m_111306_()))).booleanValue()) continue;
            quads.add(bakedQuad);
        }
        return quads;
    }

    private List<BakedQuad> getQuadsForSide(BlockState mirrorState, BlockState baseState, Direction side, Random rand, IModelData extraData) {
        List<BakedQuad> quads = super.render(mirrorState, baseState, MC.m_91289_().m_110910_(mirrorState), side, rand, extraData);
        super.render(mirrorState, baseState, MC.m_91289_().m_110910_(mirrorState), null, rand, extraData).stream().filter(q -> q.m_111306_() == side).forEach(quads::add);
        return quads;
    }

    @SubscribeEvent
    public static void onModelsReady(ModelBakeEvent event) {
        glassModel = event.getModelManager().m_119422_(BlockModelShaper.m_110895_((BlockState)Blocks.f_50058_.m_49966_()));
    }
}

